import { View, Text, Pressable } from 'react-native';
import React, { useEffect, useState } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { BASE_API_URL_STG } from '@env';
import useAuth from '../../../hooks/useAuth';
import OrderAddresses from './OrderAddresses';
import AddNewAddressBtn from './AddNewAddressBtn';
import { InOnScreenLoader } from '../ShoppingCart';
import { useIsFocused } from '@react-navigation/native';
import { billingInfoStyle } from './BillingInformationStyle';
import { OrderIndicator } from '../OrderSummary/OrderSummary';
import useLangTranslation from '../../../hooks/useLangTranslation';
import CommonStyles from '../../Utilities/CommonStyles/CommonStyles';
import { orderSummaryStyle } from '../OrderSummary/OrderSummaryStyle';
import { resetCity } from '../../../redux/slices/user/address/getCity';
import { storeSelectedItemsResData } from '../utils/storeSelectedItems';
import BackNavigation from '../../Utilities/CustomHeader/BackNavigation';
import { resetState } from '../../../redux/slices/user/address/getStates';
import { getCartProduct } from '../../../redux/slices/cart/getCartProducts';
import { resetCountry } from '../../../redux/slices/user/address/getCountries';
import { getMyAddress } from '../../../redux/slices/user/address/getMyAddress';
import { loginStyles } from '../../../components/Authentication/Login/LoginStyle';
import AddressSkeleton from '../../../src/skeletons/screens/profile/AddressSkeleton';
import { postSelectProduct } from '../../../redux/slices/cart/selectProduct/selectProduct';

const CHANGE_SHIPPING_ADDRESS_URL = `${BASE_API_URL_STG}/user/order-get-shipping-tax`;
const CARTURL = `${BASE_API_URL_STG}/user/carts`;

const GuestBillingInformation = (props) => {
	const { navigation } = props;
	const dispatch = useDispatch();
	const isFocused = useIsFocused();
	const { access_token } = useAuth();
	const { trans } = useLangTranslation();

	const { newAddress } = useSelector((state) => state.postNewAddress);
	const { cartLoading } = useSelector((state) => state.cartProductSlice);

	const [priceData, setPriceData] = useState({});
	const [inFileLoad, setInFileLoad] = useState(true);
	const [borderColor, setBorderColor] = useState(null);
	const [shippingAddress, setShippingAddress] = useState(null);
	const [selectedProducts, setSelectedProducts] = useState([]);
	const [isChangeShippingAddress, setIsChangeShippingAddress] = useState(false);

	useEffect(() => {
		if (isFocused) {
			dispatch(resetCountry());
			dispatch(resetState());
			dispatch(resetCity());
		}
	}, [isFocused]);

	useEffect(() => {
		const handleSelectAddress = async (address, id) => {
			if (id) {
				setIsChangeShippingAddress(true);
				const data = {
					country: address.country,
					state: address.state,
					city: address.city,
					zip: address.zip,
				};
				const r = await dispatch(
					postSelectProduct({
						selectURL: CHANGE_SHIPPING_ADDRESS_URL,
						method: 'POST',
						data,
					})
				);
				setBorderColor(id);
				setShippingAddress(address);
				setIsChangeShippingAddress(false);
			}
		};

		if (Object.keys(newAddress).length === 0) {
			setShippingAddress(null);
		} else {
			handleSelectAddress(newAddress, newAddress.id);
		}
	}, [newAddress]);

	useEffect(() => {
		(async () => {
			const res = await dispatch(getCartProduct({ access_token, CARTURL }));
			const selectedCarts = res?.payload?.records?.data?.selectedCarts;
			const cartData = res?.payload?.records?.data?.cartData;
			if (selectedCarts?.length > 0) {
				const isCheck = selectedCarts;
				const { selectedItems, priceData } = storeSelectedItemsResData(
					isCheck,
					cartData
				);
				setPriceData(priceData);
				setSelectedProducts(selectedItems);
				await dispatch(getMyAddress(access_token));
				setInFileLoad(false);
			} else {
				navigation.navigate('my cart');
				return;
			}
		})()
	}, []);

	return (
		<>
			{(cartLoading || isChangeShippingAddress) && <InOnScreenLoader />}
			<BackNavigation
				navigationProps={navigation}
				routeName={trans('Shipping Address')}
				capitalize={false}
			/>

			<View style={CommonStyles.globalContainer}>
				<View style={orderSummaryStyle.indicatorCont}>
				{['#33C172', '#A9DFC1', '#DFDFDF', '#DFDFDF'].map(
					(item, i) => (
						<OrderIndicator key={`key${i}`} bg={item} />
					)
                )}
				</View>

				<AddNewAddressBtn />

				{inFileLoad ? (
                    <AddressSkeleton />
                ) : (
                    shippingAddress ? (
						<OrderAddresses
							addresses={[shippingAddress]}
							borderColor={borderColor}
						/>
					):null
				)}

				<Pressable
					style={[
						loginStyles.loginButton,
						billingInfoStyle.checkoutBtn,
						billingInfoStyle.checkoutBtnBg(shippingAddress)
					]}
					onPress={() =>
						props.navigation.navigate('guest order summary', {
							priceData,
							selectedProducts,
							shippingAddress,
						})
					}
					disabled={ shippingAddress === null ? true : false }
				>
					<Text style={loginStyles.loginButtonText}>{trans('Checkout')}</Text>
				</Pressable>
			</View>
		</>
	);
};

export default GuestBillingInformation;
